/** \file optimizer_actions.h  Functions for instrumenting and controlling
 *                             optimizations.
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_OPT_ACT_H
#define __MOD_OPT_ACT_H

#include "mod_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Prototype of an action function to be called during optimization */
typedef int (*cb_action)(void *actiondata, void *optobj);

/** Create a new action */
void new_optimizer_action(struct optimizer *opt, cb_action actionfunc,
                          cb_free freefunc, void *actiondata, int skip,
                          mbool first, mbool last);

/** Remove all of this optimizer's actions */
void free_optimizer_actions(struct optimizer *opt);

#ifdef __cplusplus
}
#endif
#endif  /* __MOD_OPT_ACT_H */
