# Example for: model.make_chains()

# This will read a PDB file (segment), and write out all of its chains
# satisfying the listed conditions into separate alignment files in the
# PIR format.

from modeller import *

env = environ()
mdl = model(env, file='../atom_files/pdb1lzd.ent')
mdl.make_chains(file='1lzd', minimal_chain_length=30, minimal_resolution=2.0,
                minimal_stdres=30, chop_nonstd_termini=True,
                structure_types='structureN structureX',
                alignment_format='PIR')
