import _modeller
from modeller.util.modobject import modobject

class io_data(modobject):
    """Controls reading from/writing to atom files"""

    hetatm = False
    hydrogen = False
    water = False
    atom_files_directory = ''
    __modpt = None

    def __init__(self, copy=None, **kwargs):
        self.__modpt = _modeller.mod_io_data_new()
        if copy:
            for member in copy.__dict__:
                if 'io_data' not in member:
                    self.__dict__[member] = copy.__dict__[member]
        for key in kwargs:
            if key in dir(io_data):
                exec("self."+key+"="+str(kwargs[key]))
            else:
                raise KeyError(str(key))

    def __setstate__(self, d):
        self.__dict__.update(d)
        self.__modpt = _modeller.mod_io_data_new()

    def __del__(self):
        if self.__modpt:
            _modeller.mod_io_data_free(self.__modpt)

    def __get_modpt(self):
        modpt = self.__modpt
        _modeller.mod_io_data_set(modpt, self.hydrogen, self.hetatm, self.water,
                                  self.atom_files_directory)
        return modpt

    modpt = property(__get_modpt)
