# Step 2: family alignment
#
# Prepare an initial multiple family alignment of all structures and sequences
# related to your target sequence. For simplicity, only those structures found
# by search.py are aligned here. In general, you should add all the related
# structures found in the chains database and all the
# related sequences that you can find by FASTA, BLAST, in papers, etc. For
# example, 2fdn, identified by search.py, is also related to
# 1clf 1fca 1fdn 1fdx 2fdn, as found in the chains database .grp file.
#
# Note: if you wanted to align more than one sequence (in addition to the
#       target sequence) you'd have to modify the 'align_strs_seq' routine.

from modeller import *
from modeller.scripts import align_strs_seq

log.verbose()
env = environ()

# Directories with input atom files:
env.io.atom_files_directory = ['.', '../atom_files']

aln = align_strs_seq(env,
                     # Name of the input file specifying templates and the
                     # target sequence:
                     segfile='alignment.seg',
                     # Output alignment filename ('PIR' format)
                     alnfile='alignment.seg.ali',
                     # Structures' PDB codes:
                     knowns=('1fdn', '5fd1', '1fxd', '1iqz'),
                     # Target sequence code:
                     sequence='1fdx',
                     # Identity matrix filename:
                     matrix_file='fer2.id.mat',
                     overhang=4,
                     # Write out the superposed structures:
                     write_fit=True)

# Write out the alignment in the 'PAP' format, too:
aln.write(file='alignment.seg.pap', alignment_format='PAP')
