from modeller import *

env = environ()
env.io.atom_files_directory = ['.', '../atom_files']

aln = alignment(env)

# Read in the 1y7t template structure and add to alignment
mdl = model(env, file='1y7t', model_segment=('FIRST:A','LAST:A'))
aln.append_model(mdl, align_codes='1y7tA', atom_files='1y7t')

# Add in the TvLDH sequence
aln.append(file='../step1_search/TvLDH.ali', align_codes='TvLDH')

# Sequence/structure alignment
aln.align2d(max_gap_length=40)

# Write out resulting alignment in both PIR and PAP formats
aln.write(file='TvLDH-1y7tA.ali', alignment_format='PIR')
aln.write(file='TvLDH-1y7tA.pap', alignment_format='PAP')
