#  ============================================================================
#
#  a. Define the type of oprimization: conjugate gradients minimization (CG)
#     or molecular dynamics (MD)
#  b. Edit input parameters: density map parameters and probe structure
#
#  =======================  Maya Topf, 4 Dec 2007 =============================

from modeller import *
import shutil
import sys, os, os.path
import string
import math
from CG import opt_cg
from MD import opt_md

env = environ()

############### INPUT PARAMETERS ##################
optimization = 'MD'                     # type of optimization: CG / MD
rigid_filename = 'rigid.txt'            # rigid bodies file name
path = './'                             # directory path
code = '1ake'                           # 4 letter code of the structure
input_pdb_file = '1ake_init.pdb'        # input model for optimization
em_map_file = '1ake_10A.mrc'            # name of EM density map (mrc)
format='MRC'                            # map format: MRC or XPLOR
apix=1.0                                # voxel size: A/pixel
box_size=69                             # size of the density map (cubic)
resolution=10.0                         # resolution
x=-9.0; y=14.0; z=-8.0                  # origin of the map
num_of_runs = 1                         # number of runs
initial_dir = 1

############### RUN OPTIMIZATION ##################
#  CG
# ----
if optimization == 'CG':
    for i in range(initial_dir,initial_dir+num_of_runs):
        scratch = path + '/' + str(i) + '/'
        os.system("mkdir -p " + scratch)
        os.system("cp " + path + '/'+ input_pdb_file + " " + scratch)
        os.chdir(scratch)
        opt_cg(path, code, str(i), 55*i, em_map_file, input_pdb_file,
                format, apix, box_size, resolution, x, y, z, rigid_filename)

#  MD
# ----
elif optimization == 'MD':
    for i in range(initial_dir,initial_dir+num_of_runs):
        scratch = path + '/' + str(i) + '/'
#       input_pdb_file = 'final' + str(i) + '_cg.pdb'
#       os.chdir(scratch)
        opt_md(path, code, str(i), 10*i, em_map_file, input_pdb_file,
                format, apix, box_size, resolution, x, y, z, rigid_filename)
