#   residue   spline values
chi3 = [
    ( 'GLU', (0.7042, 0.7802, 0.8771, 0.9889, 1.1371, 1.2801, 1.4109, 1.5284, 1.6357, 1.7409, 1.8320, 1.9260, 2.0236, 2.1095, 2.2274, 2.3285, 2.4025, 2.4686, 2.4831, 2.5169, 2.5423, 2.5482, 2.5519, 2.5387, 2.5183, 2.5069, 2.4914, 2.4789, 2.4720, 2.4490, 2.4238, 2.3679, 2.2975, 2.1650, 1.9757, 1.7683, 1.5486, 1.3734, 1.2384, 1.1226, 1.0278, 0.9303, 0.8184, 0.6940, 0.5458, 0.3936, 0.2515, 0.1354, 0.0564, 0.0119, 0.0000, 0.0056, 0.0265, 0.0462, 0.0579, 0.0723, 0.0798, 0.0917, 0.1119, 0.1262, 0.1312, 0.1304, 0.1180, 0.0988, 0.0872, 0.0717, 0.0529, 0.0382, 0.0199, 0.0076, 0.0074, 0.0165, 0.0361, 0.0626, 0.0914, 0.1146, 0.1341, 0.1518, 0.1653, 0.1853, 0.2090, 0.2291, 0.2543, 0.2746, 0.2858, 0.3014, 0.3073, 0.3103, 0.3129, 0.3003, 0.2867, 0.2689, 0.2447, 0.2274, 0.2239, 0.2420, 0.3022, 0.3970, 0.5176, 0.6532, 0.7720, 0.8781, 0.9599, 1.0291, 1.1037, 1.1966, 1.3265, 1.4953, 1.7052, 1.8997, 2.0575, 2.1670, 2.2152, 2.2541, 2.2906, 2.3079, 2.3044, 2.2952, 2.2821, 2.2658, 2.2635, 2.2652, 2.2580, 2.2519, 2.2399, 2.2183, 2.2041, 2.1802, 2.1376, 2.0827, 2.0067, 1.9185, 1.8295, 1.7362, 1.6286, 1.5183, 1.3902, 1.2542, 1.1173, 0.9804, 0.8574, 0.7629, 0.6927, 0.6383) ),
    ( 'LYS', (0.0271, 0.1449, 0.3038, 0.5077, 0.7887, 1.0805, 1.3664, 1.6404, 1.8977, 2.1430, 2.3619, 2.5533, 2.7206, 2.8687, 3.0115, 3.1478, 3.2886, 3.4151, 3.5316, 3.6495, 3.7439, 3.8268, 3.8853, 3.9193, 3.9391, 3.9561, 3.9569, 3.9246, 3.8781, 3.8091, 3.7364, 3.6686, 3.6057, 3.5326, 3.4437, 3.3420, 3.2094, 3.0744, 2.9194, 2.7464, 2.5673, 2.3771, 2.2014, 2.0513, 1.9448, 1.8972, 1.9197, 2.0223, 2.2040, 2.4639, 2.7838, 3.1319, 3.4784, 3.7931, 4.0639, 4.3222, 4.5655, 4.7544, 4.9138, 5.0164, 5.0720, 5.1564, 5.2234, 5.2833, 5.3565, 5.4018, 5.4633, 5.5175, 5.5516, 5.5632, 5.5710, 5.5477, 5.5288, 5.5065, 5.4563, 5.4085, 5.3439, 5.3041, 5.2658, 5.2543, 5.2345, 5.1538, 5.0720, 4.9595, 4.8565, 4.7772, 4.6729, 4.5484, 4.3600, 4.1350, 3.8774, 3.5738, 3.2409, 2.8881, 2.5562, 2.2855, 2.0924, 1.9827, 1.9597, 2.0088, 2.1149, 2.2671, 2.4375, 2.6130, 2.7916, 2.9549, 3.1096, 3.2478, 3.3514, 3.4460, 3.5164, 3.5818, 3.6651, 3.7252, 3.7937, 3.8581, 3.8882, 3.9368, 3.9702, 3.9854, 3.9983, 3.9561, 3.8788, 3.7701, 3.6426, 3.5159, 3.3985, 3.2902, 3.1621, 3.0336, 2.8894, 2.7254, 2.5562, 2.3616, 2.1375, 1.8969, 1.6308, 1.3487, 1.0597, 0.7638, 0.4829, 0.2796, 0.1200, 0.0000) ),
    ( 'MET', (1.1574, 1.2087, 1.2714, 1.3595, 1.4662, 1.5691, 1.6758, 1.7677, 1.8707, 1.9766, 2.0852, 2.2039, 2.3073, 2.4080, 2.4879, 2.5486, 2.6003, 2.6412, 2.6761, 2.6863, 2.6799, 2.6547, 2.5979, 2.5486, 2.4858, 2.4041, 2.3349, 2.2451, 2.1432, 2.0398, 1.9172, 1.7848, 1.6350, 1.4519, 1.2451, 1.0280, 0.8115, 0.6166, 0.4389, 0.2823, 0.1583, 0.0629, 0.0067, 0.0000, 0.0334, 0.1109, 0.2355, 0.3903, 0.5848, 0.8166, 1.0672, 1.3267, 1.5720, 1.7932, 1.9958, 2.2047, 2.4227, 2.6157, 2.7568, 2.8551, 2.9098, 2.9762, 3.0528, 3.1438, 3.2307, 3.2923, 3.3655, 3.4121, 3.4893, 3.5636, 3.6013, 3.6240, 3.6013, 3.5483, 3.4921, 3.4499, 3.3937, 3.3554, 3.3065, 3.2598, 3.2131, 3.1602, 3.1041, 3.0058, 2.9162, 2.8193, 2.7283, 2.6635, 2.5475, 2.3945, 2.1936, 1.9548, 1.7110, 1.4556, 1.2093, 0.9643, 0.7384, 0.5375, 0.3680, 0.2430, 0.1667, 0.1494, 0.1860, 0.2773, 0.4127, 0.5693, 0.7340, 0.8763, 0.9890, 1.0867, 1.1784, 1.2946, 1.4371, 1.5946, 1.7682, 1.9395, 2.0958, 2.2320, 2.3643, 2.4691, 2.5610, 2.6387, 2.6685, 2.6572, 2.6133, 2.5759, 2.5386, 2.5221, 2.5156, 2.4774, 2.4178, 2.3277, 2.2215, 2.1030, 1.9919, 1.8873, 1.7791, 1.6725, 1.5599, 1.4467, 1.3474, 1.2828, 1.2361, 1.2072) ),
    ( 'PRO', (5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8851, 5.8728, 5.8487, 5.8194, 5.8022, 5.7416, 5.3780, 4.6756, 3.8474, 2.4551, 1.3491, 0.6887, 0.2521, 0.0143, 0.0000, 0.1228, 0.3642, 0.7175, 1.0675, 1.4098, 1.7629, 2.0801, 2.3304, 2.5178, 2.6411, 2.7081, 2.7328, 2.7236, 2.7042, 2.6697, 2.6140, 2.5274, 2.3822, 2.1914, 1.9630, 1.7056, 1.4478, 1.2029, 0.9781, 0.7678, 0.5588, 0.3699, 0.2680, 0.2695, 0.4172, 0.7777, 1.3230, 2.1398, 3.4142, 4.5003, 5.1379, 5.6256, 5.8252, 5.8607, 5.8607, 5.8728, 5.8851, 5.8913, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975, 5.8975) ),
    ( 'GLN', (1.2136, 1.2470, 1.2852, 1.3289, 1.3907, 1.4515, 1.5015, 1.5508, 1.5817, 1.5943, 1.6201, 1.6547, 1.6916, 1.7257, 1.7530, 1.7509, 1.7546, 1.7605, 1.7472, 1.7398, 1.7123, 1.6723, 1.6356, 1.6155, 1.6113, 1.6304, 1.6547, 1.6620, 1.6542, 1.6314, 1.6025, 1.5732, 1.5400, 1.5007, 1.4610, 1.4151, 1.3691, 1.3072, 1.2260, 1.1101, 0.9737, 0.8283, 0.6787, 0.5438, 0.4097, 0.2801, 0.1697, 0.0810, 0.0214, 0.0009, 0.0000, 0.0132, 0.0411, 0.0796, 0.1284, 0.1919, 0.2594, 0.3093, 0.3617, 0.4064, 0.4498, 0.5027, 0.5568, 0.6073, 0.6583, 0.7105, 0.7464, 0.7855, 0.8103, 0.8255, 0.8434, 0.8531, 0.8624, 0.8624, 0.8563, 0.8406, 0.8247, 0.8105, 0.7910, 0.7652, 0.7307, 0.7045, 0.6763, 0.6537, 0.6266, 0.5692, 0.5088, 0.4426, 0.3823, 0.3348, 0.2803, 0.2264, 0.1667, 0.1226, 0.1077, 0.1242, 0.1898, 0.2836, 0.4038, 0.5356, 0.6507, 0.7611, 0.8498, 0.9342, 1.0310, 1.1152, 1.2098, 1.2860, 1.3401, 1.4027, 1.4436, 1.4880, 1.5099, 1.5078, 1.5119, 1.5124, 1.5293, 1.5490, 1.5578, 1.5564, 1.5404, 1.5331, 1.5246, 1.5297, 1.5525, 1.5741, 1.6012, 1.6131, 1.6113, 1.5898, 1.5630, 1.5460, 1.5331, 1.5182, 1.5053, 1.4855, 1.4456, 1.4072, 1.3366, 1.2499, 1.1609, 1.0850, 1.0362, 0.9969) ),
    ( 'ARG', (0.0000, 0.0797, 0.1956, 0.3605, 0.5872, 0.8482, 1.1245, 1.3937, 1.6599, 1.9055, 2.1284, 2.3355, 2.5266, 2.6868, 2.8403, 2.9618, 3.0586, 3.1557, 3.2173, 3.2738, 3.3209, 3.3695, 3.4356, 3.4708, 3.4791, 3.4535, 3.3905, 3.3417, 3.2913, 3.2302, 3.1504, 3.0459, 2.9503, 2.8481, 2.7371, 2.6140, 2.4390, 2.2358, 2.0031, 1.7480, 1.4968, 1.2555, 1.0370, 0.8585, 0.7255, 0.6479, 0.6350, 0.6818, 0.7895, 0.9509, 1.1596, 1.4078, 1.6864, 1.9882, 2.2753, 2.5641, 2.8334, 3.0814, 3.3425, 3.5552, 3.7260, 3.8536, 3.9722, 4.0845, 4.2091, 4.3339, 4.4132, 4.4740, 4.5097, 4.5467, 4.5824, 4.6281, 4.6853, 4.7426, 4.7726, 4.7296, 4.6281, 4.4790, 4.3559, 4.2364, 4.1386, 4.0413, 3.9033, 3.7684, 3.5898, 3.3787, 3.1444, 2.9018, 2.6421, 2.3603, 2.0908, 1.8061, 1.5443, 1.3181, 1.1095, 0.9484, 0.8312, 0.7658, 0.7682, 0.8318, 0.9596, 1.1415, 1.3640, 1.6136, 1.8632, 2.0984, 2.2964, 2.4649, 2.6218, 2.7713, 2.9308, 3.0672, 3.1747, 3.2558, 3.3138, 3.3812, 3.4454, 3.5054, 3.5572, 3.5733, 3.5582, 3.5393, 3.4969, 3.4517, 3.4215, 3.3563, 3.2745, 3.1747, 3.0526, 2.9298, 2.8037, 2.6583, 2.4808, 2.2720, 2.0256, 1.7607, 1.4763, 1.1845, 0.9098, 0.6511, 0.4226, 0.2648, 0.1425, 0.0521) ),
  ]

def make_restraints(atmsel, restraints, num_selected):
    from modeller import forms, physical, features
    for (res, values) in chi3:
        arr = True
        for a in atmsel.find_chi3_dihedrals(res, num_selected):
            r = forms.spline(physical.chi3_dihedral,
                             features.dihedral(*a), open=False, low=-3.11978,
                             high=3.16341, delta=0.04363, lowderiv=0,
                             highderiv=0, values=values, use_array=arr)
            arr = restraints.add(r)
