# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


def frange(start, end=None, step=None):
    """This routine is similar to the 'range' function but returns
    a list of floating point numbers instead of integers."""

    if end == None:
        end = start + 0.0
        start = 0.0

    if step == None:
        step = 1.0

    count = int((end - start)/step)
    if start + (count*step) != end:
        count += 1

    L = [None,]*count
    for i in range(count):
        L[i] = start + i*step

    return L
