#!/usr/bin/python
# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

from modeller import *
from optparse import OptionParser
import modpipe.version
import sys, os

def main():

    # Parse command line options
    parser = OptionParser(version=modpipe.version.message())

    # Set defaults
    parser.set_usage("""
 This script takes a list of locations to sequence profiles and creates
 a database of PSSMs.

 Usage: %prog [options] inpfile outfile

 inpfile is a file containing a list of sequence profiles to be
 converted to PSSMs.

 outfile is the name of the output PSSM database.

 Run `%prog -h` for help information
 """)

    opts, args = parser.parse_args()

    if len(args) != 2:
        parser.error("Need both an input file and an output file")
    inpfile, outfile = args

    # -- Initialize some modeller stuff
    log.verbose()
    env = environ()

    env.make_pssmdb(profile_list_file = inpfile,
                    profile_format = 'text',
                    pssmdb_name = outfile,
                    matrix_offset = -450,
                    rr_file = '$(LIB)/blosum62.sim.mat',
                    pssm_weights_type = 'HH1'
                   )

if __name__ == "__main__":
    main()
