# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

package Types::IntAlignment;

use strict;
use Class::Struct;

# -- Each component of this data structure
#    holds an array of the named type
#    corresponding to the alignment. An
#    alignment is a set of more than 1
#    sequences.

struct IntAlignment => {

   # -- Name of the alignment file
   filename   => '$',

   # -- The align code (unique identifier in the 
   #    alignment).
   code      => '@',

   # -- The type of the sequence (structure, sequence
   #    etc)
   type      => '@',

   # -- Location of the coordinate file. Makes sense
   #    only for structures
   file      => '@',

   # -- Beginning position of the sequence in the 
   #    alignment
   inipos    => '@',

   # -- The chain identifier (goes with inipos)
   chain1    => '@',

   # -- Ending position of the sequence in the 
   #    alignment
   endpos    => '@',

   # -- Chain identifier corresponding to endpos
   chain2    => '@',

   # -- The names of all aligned sequences
   name      => '@',

   # -- The sources of all aligned sequences
   source    => '@',

   # -- The resolutions of all aligned sequences
   #    Makes sense only for structures
   resoln    => '@',

   # -- The R-Factors of all aligned sequences
   #    Makes sense only for structures
   rfactr    => '@',

   # -- The aligned sequences in the standard
   #    horizontal form, i.e., one row per
   #    aligned sequence.  
   sequence  => '@',

   # -- The aligned sequences in a vertical form, 
   #    i.e., one row for every column in the alignment
   seqvert   => '@', 
                    };

1;
