# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


"""This contains modules that have utilities for manipulating
PDB, alignment, profiles etc.
"""

# Version check (need Python 2.4 or later for subprocess module etc.)
import sys
if sys.version_info[0] < 2 \
   or (sys.version_info[0] == 2 and sys.version_info[1] < 4):
    raise ImportError("ModPipe requires Python 2.4 or later")

class Error(Exception):
    """Generic ModPipe error."""
    pass

class FileFormatError(Error):
    """Raised when trying to read a file that is of the wrong format."""
    pass

class MissingBinaryError(Error):
    """Raised when trying to use an external binary (e.g. BLAST) that
       ModPipe was not configured with."""
    pass
