#!/usr/bin/perl -w

use Test::More 'no_plan';
use File::Temp;
use strict;

BEGIN {
    use_ok('PLLib::Alignment');
}

# Test ClusterAlignments
{
   my $tmpdir = File::Temp::tempdir(CLEANUP=>1);
   ok(chdir($tmpdir), "chdir into tempdir");

   my @aliobjects;
   ok(open(FH, ">", "test1.ali"));
   print FH ">P1;seq\nsequence::1::8:::::\nAYVINDSC*\n";
   print FH ">P1;test1\nsequence::1::8:::::\nAYVINDSC*\n";
   ok(close(FH));
   push @aliobjects, ReadAlignment(undef, "test1.ali", 'PIR', 'VERTICAL');

   ok(open(FH, ">", "test2.ali"));
   print FH ">P1;seq\nsequence::1::8:::::\nAYVINDSC*\n";
   print FH ">P1;test2\nsequence::1::8:::::\nAYVINDSG*\n";
   ok(close(FH));
   push @aliobjects, ReadAlignment(undef, "test2.ali", 'PIR', 'VERTICAL');

   ok(open(FH, ">", "test3.ali"));
   print FH ">P1;seq\nsequence::1::8:::::\nAYVINDSC*\n";
   print FH ">P1;test3\nsequence::1::8:::::\nAYVINDSG*\n";
   print FH ">P1;test4\nsequence::1::8:::::\nAYVINDSG*\n";
   ok(close(FH));
   push @aliobjects, ReadAlignment(undef, "test3.ali", 'PIR', 'VERTICAL');

   my ($repstack, $clusters) = ClusterAlignments(\@aliobjects, 'seq', 0, 60,
                                                 20, 20, 0, 80);
   cmp_ok(scalar(@$repstack), "==", 2);
   cmp_ok(scalar(@$clusters), "==", 2);
   # Alignments of different numbers of sequences should never cluster together
   is($repstack->[1]->filename, "test3.ali");

   chdir('/') # Allow the temporary directory to be deleted
}
