from __future__ import print_function
import unittest
import os
import sys
import shutil
import modpipe.test
import modpipe.serialize
import subprocess
import gzip
import glob

class BenchmarkTests(modpipe.test.TestCase):

    def test_benchmark(self):
        """Check BenchMark.pl"""
        binary = self.get_modpipe_binary_path('main/BenchMark.py')
        conf = 'modpipe.conf'
        with open(conf, 'w') as fh:
            print("DATDIR  %s" % os.getcwd(), file=fh)
        seq_md5 = 'd18b74a08d8b83e15835daaf76471976FCGHGNVV'
        model_md5 = '7728c533e21577f46dfafc200cdcc2a2'
        model_out = 'model_out.yaml'
        if os.path.exists('d18'):
            shutil.rmtree('d18')
        os.mkdir('d18')
        os.mkdir('d18/%s' % seq_md5)
        os.mkdir('d18/%s/sequence' % seq_md5)
        os.mkdir('d18/%s/models' % seq_md5)
        shutil.copy('data/%s.fsa' % seq_md5, 'd18/%s/sequence/' % seq_md5)
        shutil.copy('data/%s.mod' % seq_md5, 'd18/%s/sequence/' % seq_md5)
        shutil.copy('data/%s.pdb.gz' % model_md5, 'd18/%s/models/' % seq_md5)
        native = open('pdb1foo.ent', 'w')
        for line in gzip.open('data/%s.pdb.gz' % model_md5,
                              'rt' if sys.version_info[0] >= 3 else 'r'):
            # Shift one atom by 2.5A so the models aren't exactly
            # the same at cutoffs of more than 2.5A
            if line.startswith('ATOM      2  CA'):
                line = line[:40] + '41.745' + line[46:]
            native.write(line)
        native.close()
        p = subprocess.Popen([binary, '--conf_file', conf, '--sequence_id',
                              seq_md5, '--native', '1foo',
                              '--pdb_repository', '.', '--native_chain', 'A',
                              '--output_filename', model_out],
                              stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        lines = p.stdout.readlines()
        p.stdout.close()
        print(p.stderr.read())
        p.stderr.close()
        self.require_clean_exit(p)
        model_out = os.path.join('d18',seq_md5,'sequence', model_out)
        print(model_out)
        with open(model_out) as fh:
            models = list(modpipe.serialize.read_models_file(fh))
        self.assertEqual(len(models), 1)
        b = models[0].native_benchmark
        self.assertEqual(b['chain'], 'A')
        self.assertEqual(b['code'], '1foo')
        self.assertEqual(b['num_equiv_pos_35'], 116)
        self.assertAlmostEqual(b['global_rms'], 0.229, places=3)
        self.assertEqual(b['length'], 116)
        self.assertAlmostEqual(b['mean_cutoff_rms'], 0.152, places=3)
        self.assertEqual(b['mean_num_equiv_pos'], 115)
        self.assertEqual(len(b['cutoff_rms']), 5)
        for r in b['cutoff_rms'][:2]:
            self.assertAlmostEqual(r['rms'], 0.037, places=3)
            self.assertEqual(r['num_equiv_pos'], 115)
        for r in b['cutoff_rms'][2:]:
            self.assertAlmostEqual(r['rms'], 0.229, places=3)
            self.assertEqual(r['num_equiv_pos'], 116)
        os.unlink(conf)
        os.unlink(model_out)
        os.unlink('pdb1foo.ent')
        os.unlink('d18/%s/sequence/%s.fsa' % (seq_md5, seq_md5))
        os.unlink('d18/%s/sequence/%s.mod' % (seq_md5, seq_md5))
        os.unlink('d18/%s/models/%s.pdb.gz' % (seq_md5, model_md5))
        os.rmdir('d18/%s/models' % seq_md5)
        os.rmdir('d18/%s/sequence' % seq_md5)
        os.rmdir('d18/%s' % seq_md5)
        os.rmdir('d18')

if __name__ == '__main__':
    unittest.main()
