#!/usr/bin/perl -w

use Test::More 'no_plan';
use File::Temp;
use strict;

BEGIN {
    use_ok('PLLib::Sequence');
}

# Test GetPercGaps
{
   my $tmpdir = File::Temp::tempdir(CLEANUP=>1);
   ok(chdir($tmpdir), "chdir into tempdir");

   ok(open(FH, ">", "test1.ali"));
   print FH ">P1;seq\nsequence::1::8:::::\nAYVINDSC*\n";
   print FH ">P1;test1\nsequence::1::8:::::\nGG---DGC*\n";
   print FH ">P1;test2\nsequence::1::8:::::\nAYVGND-C*\n";
   ok(close(FH));
   my ($gap_perc, $maxseq_ident) = GetPercGaps("test1.ali", "PIR", "seq");
   # gap percentage and seq identity should be of the "best" sequence (test2)
   cmp_ok(int($gap_perc), "==", 14);
   cmp_ok($maxseq_ident, "==", 86);

   ok(open(FH, ">", "test2.ali"));
   print FH ">P1;seq\nsequence::1::8:::::\nAYVINDSC--------*\n";
   print FH ">P1;test1\nsequence::1::8:::::\n--------AYVINDSC*\n";
   ok(close(FH));
   ($gap_perc, $maxseq_ident) = GetPercGaps("test2.ali", "PIR", "seq");
   # No aligned positions
   cmp_ok($gap_perc, "==", 100);
   cmp_ok($maxseq_ident, "==", 0);

   chdir('/') # Allow the temporary directory to be deleted
}
