# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

package PLLib::Procheck;
require Exporter;
@ISA    = qw(Exporter);
@EXPORT = qw( RunProcheck );

use strict;
use PLLib::Utils;
use File::Basename;

sub RunProcheck {

   # --- Get subroutine name
   my $subname = GetSubrName();

   # --- Check arguments
   my $nargs = 4;

   unless ( scalar(@_) == $nargs ){
      print "${subname}__D> Insufficient arguments\n";
      return;
   }

   # --- Reassign input arguments
   my ($procheck, $modfile, $modchain, $modresol) = @_;
   my $sumfile = substr($modfile,0,-4).".sum";

   # --- Check if exe exists
   unless ( -f $procheck && -x $procheck ){
      print "${subname}__E> Could not find PROCHECK executable\n";
      print "${subname}__E>    PROCHECK = $procheck\n";
      return;
   }

   # --- Actually run PROCHECK
   my $retval = system("$procheck $modfile $modchain $modresol >& /dev/null");

   # --- Check return value
   if ( $retval ){
      print "${subname}__E> PROCHECK failed\n";
      return;
   }

   # --- Check for sum file
   unless ( -s $sumfile ){
      print "${subname}__E> PROCHECK produced no (or empty) summary file\n";
      return;
   }

   # --- Check for errors in the sum file
   my $fh_sum = OpenFile($sumfile); 
   unless ( grep /P  R  O  C  H  E  C  K/, <$fh_sum> ){
     print "${subname}__E> PROCHECK produced errors\n";
     return ;
   }
   close($fh_sum);

   return 1;
}
