# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


import subprocess, re, sys
import os

def get_arch():
    """This returns the architecture of the machine using
    the built-in function in Python."""
    arch = os.uname()[-1]
    return arch.strip(' \n')


def get_arch_by_uname():
    """This uses the output of `uname -m` to get the
    architecture of the machine."""
    arch = subprocess.Popen(["uname", "-m"],
                   stdout=subprocess.PIPE).communicate()[0]
    return arch.strip(' \n')

def open_output_stream(outfile):
    fhout=None
    if outfile is not None:
        p = re.compile(r'\*stdout', re.IGNORECASE)
        if p.search(outfile):
            fhout=sys.stdout
        else:
            fhout=open(outfile, "w")
    else:
        fhout=sys.stdout
    return fhout

def close_output_stream(fh):
    if fh is not sys.stdout:
        fh.close()
