import unittest
import os
import modpipe.test
import modpipe.binaries
import subprocess
import re

class JessTests(modpipe.test.TestCase):

    def test_jess(self):
        """Check jess"""
        binary = modpipe.binaries.get_tess2jess()
        ex_jess = 'example.jess'
        out = open(ex_jess, 'w')
        p = subprocess.Popen([binary, 'data/example.tess'],
                             stdout=out)
        self.require_clean_exit(p)
        out.close()
        binary = modpipe.binaries.get_jess()
        p = subprocess.Popen([binary, '-t', ex_jess, '-m',
                              'data/pdb1tim.ent', '-d', 'delta=2.0', '-f'],
                              stdout=subprocess.PIPE, universal_newlines=True)
        srch = re.compile(r'serial=\"(\d+)\"')
        serials = re.findall(srch, p.stdout.read())
        self.require_clean_exit(p)
        p.stdout.close()
        os.unlink(ex_jess)
        self.assertEqual(serials, ['223', '224', '225', '423', '409', '223',
                                   '224', '225', '423', '243'])

if __name__ == '__main__':
    unittest.main()
