import unittest
import os
import modpipe.test
import modpipe.binaries
import subprocess

class SegTests(modpipe.test.TestCase):

    def test_seg(self):
        """Check SEG"""
        expected_codes = ['1apxA', '1apxB', '1apxC', '1apxD', '1bwyA',
                          '1cbiA', '1ecsA', '1ecsB', '1f9zA', '1fdqA',
                          '1fljA', '1ftpA', '1g7nA', '1gglA', '1h0zA',
                          '1hcbA', '1itkA', '1iynA', '1j4wA', '1jd0A',
                          '1keqA', '1kllA', '1kopA', '1kqwA', '1llpA',
                          '1lpjA', '1lugA', '1mwvA', '1n8yC', '1o8vA',
                          '1oafA', '1opaA', '1pmpA', '1qipA', '1rj5A',
                          '1sj2A', '1sj2B', '1touA', '1u2kA', '1ub2A',
                          '1v9eA', '1vyfA', '1zbyA', '1zncA', '1b56A',
                          '1mdcA', '1hmrA', '1cbsA', '1crbA']
        binary = modpipe.binaries.get_seg()
        p = subprocess.Popen([binary, '../db/test-pdb.fsa', '-q'],
                             stdout=subprocess.PIPE,
                             universal_newlines=True)
        codes = []
        for line in p.stdout:
            if line.startswith('>'):
                codes.append(line[1:].rstrip('\r\n'))
        p.stdout.close()
        self.assertEqual(codes, expected_codes)
        self.require_clean_exit(p)

if __name__ == '__main__':
    unittest.main()
