import unittest
import modpipe.test
import modpipe.binaries
import subprocess
import tempfile
import shutil

class CETests(modpipe.test.TestCase):

    def test_ce(self):
        """Check CE"""
        ce = modpipe.binaries.get_ce()
        mkdb = modpipe.binaries.get_ce_mkdb()
        tmpdir = tempfile.mkdtemp()
        p = subprocess.Popen([ce, '-', '../db/pdb/pdb1ecs.ent', 'A',
                              '../db/pdb/pdb1tsj.ent', 'A', tmpdir, mkdb],
                              stdout=subprocess.PIPE,
                              universal_newlines=True)
        lines = p.stdout.readlines()
        p.stdout.close()
        self.require_clean_exit(p)
        self.assertEqual([line.rstrip('\r\n') for line in lines[-6:-4]],
          ['Chain 1:   72 FYRQCKSVGIQETSSGYPRIHAPELQGWGGTMAALVDPDGTLLRLIQNEL',
           'Chain 2:   86 XERLFNGLKDE-----GAILXPKTNXPPYREFAWVQDKFGVSFQLALPEE'])
        shutil.rmtree(tmpdir)

if __name__ == '__main__':
    unittest.main()
