#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "basic_mat.h"
#include "basic_ad.h"


void load_dmat(dmat * pattern, char * filename);
void load_imat(imat * imat, char * filename);

#ifndef _basic_io_


struct param{
  char   key[100];
  char   descr[100];
  char   *ps;
  char   *pc;
  int    *pi;
  double *pd;
  char   type;
} ;

extern struct param param[100];


#define _basic_io_
#endif


//--
void fprintf_dmat(FILE *fp, char *format, int n, int m, double **mat);
void fprintf_imat(FILE *fp, char *format, int n, int m, int    **mat);

void fprintf_dvec(FILE * fp, char *format, int n, double *vec);
void fprintf_ivec(FILE * fp, char *format, int n, int    *vec);
void fprintf_cvec(FILE * fp, char *format, int n, char *vec);

void fprintf_c(FILE * fp, int n, char c);
void fprintf_n(FILE * fp);


//--
void printf_dmat( char *format, int n, int m, double **mat);
void printf_imat( char *format, int n, int m, int    **mat);

void printf_dvec( char *format, int n, double *vec);
void printf_ivec( char *format, int n, int    *vec);

void printf_c( int n, char c);
void printf_n(void);

FILE *fopen_read(char *file);
FILE *fopen_write(char *file);

void get_options(int argc, char *argv[], int debug);
void get_options_str(void *pv, char key[], char descr[],char def[]);
void get_options_aux(void *pv, char key[], char descr[], char type);
