#include "bsp.h"


// Ligand
void site::read_standard(char file[])
{
  char buffer[1000];
  
  seq = new char[LENGTH+1];
  
  int n1,n2;
  char res3[4];
  char res1;
  int flag;

  FILE *fp = fopen_read(file);

  int n=0;
  while( fgets(buffer, 1000, fp) != NULL){
    if(buffer[0]=='#') continue;
    if(n >= LENGTH){
      fprintf(stderr, "\nsite::read_standard --> ERRORE Length: %d n: %d\n", LENGTH, n);
      exit(0);
    }
    sscanf(buffer, "%d %d %s %c %d", &n1, &n2, res3, &res1, &flag);
    seq[n] = res1;
    if(flag == 1 && flag_patch[n]==SURF) flag_patch[n] = PATCH;
    if(DEBUG==2){ printf("ROUTINE__read_standard__%3d %3d %c %d\n", n1, n2, res1, flag_patch[n] );}
    n++;
  }

  if(n != LENGTH){
    fprintf(stderr, "\nsite::read_standard --> ERRORE Length: %d n: %d\n", LENGTH, n);
    exit(0);
  }

  seq[LENGTH] = '\0';


  fclose(fp);
}

// Ligand
void site::read_ash_format(char file[], prot_res *pr)
{
  char buffer[1000];
  

  FILE *fp = fopen_read(file);

  char pdb_code[5];
  char lig_name[4];
  char res_name[4];
  char lig_chain;
  char res_chain;
  int lig_num;
  int res_num;

  create_core(pr);

  while( fgets(buffer, 1000, fp) != NULL){
    sscanf(buffer, "%s %s %d %c %s %d %c ", pdb_code,
	   lig_name, &lig_num, &lig_chain,
	   res_name, &res_num, &res_chain);      
    for(int i=0; i<pr->nres; i++){
      if( pr->res[i].num == res_num ){
	if( flag_patch[i] == SURF ) flag_patch[i] = PATCH;
	break;
      }
    }
  }
  
  fclose(fp);
}

// Ligand
void site::inherite_ligand(prot_res *pr)
{
  	create_core(pr);

  	for(int i=0; i<pr->nres; i++){
    	if( pr->real_patch[i] == PATCH && flag_patch[i] == SURF){
			flag_patch[i] = PATCH;
    	}
  	}
  
  	update_patch();
}

