#include "bsp.h"

/***********************************************
 **   SCORE  FUNCTION
 ************************************************/
void site::score( prot_res *pr)
{
	score_all(pr);
	
  
	for(int j=0; j<ENERGY_MAX; j++){
		if(WEIGHT[j]!= 0.0 || j == ENERGY_OVERLAP){
			if(GG_PROTEIN_STD[j] != 0.0){
				GZ[j] = (GG[j] - GG_PROTEIN_AVE[j])/GG_PROTEIN_STD[j];
			}
			else{
				GZ[j] = (GG[j] - GG_PROTEIN_AVE[j]);
			}	
		}
		else{
			GZ[j] = 0.0;
		}
	}
	
	// My method: assumes things change from protein to protein!
	if(SCORE_FLAG == 1){
		for(int j=0; j<ENERGY_MAX; j++){
			GW[j] =  WEIGHT[j] * GZ[j];
		}
	}
	// Andrej's suggestion: look at statistics of real binding sites!
	else if(SCORE_FLAG == 2){
		for(int j=0; j<ENERGY_MAX; j++){
			double x = (GG[j]-WEIGHT_AVE[j])/WEIGHT_STD[j];
			GW[j] = WEIGHT[j] *x*x;
		}
	}
	else{
		printf(" SCORE_FLAG not defined\n");
		exit(0);
	}
	
	G = 0.0;
	for(int j=0; j<ENERGY_MAX; j++){
		G +=  GW[j];
	}
}


void site::score_all( prot_res *pr)
{
  	for(int j=0; j<ENERGY_MAX; j++){
		// overlap is always calculated
		// all the other features are caluclated only if weight is not 0
		if( WEIGHT[j]!= 0.0 || j == ENERGY_OVERLAP){
			if(j == ENERGY_OVERLAP){
				GG[j] = score_overlap( pr );
			}
			else if(j == ENERGY_DIST){
				GG[j] = score_dist( pr );
			}
			else if(j == ENERGY_CNS){
				GG[j] = score_cns( pr );
			}
			else if(j == ENERGY_EPT){	
				GG[j] = score_charge_density( pr );
			}
			else if(j == ENERGY_TEMP){	
				GG[j] = score_temp_exp( pr );
			}
			else if(j == ENERGY_PROTR){	
				GG[j] = score_protrusion( pr );
			}
			else if(j == ENERGY_CONVEX){	
				GG[j] = score_convexity( pr );
			}
			else if(j == ENERGY_HYDRO){	
				GG[j] = score_hydro_miller( pr, 0 );
			}
			else;
		}
		else{
			GG[j] = 0.0;
		}
	}
}


/*----------------------------------------------------
    SCORE  FUNCTIONS
-----------------------------------------------------*/

// Score convexity
// range [0,1]
// 0.0 -> full overlap
// 1.0 -> no overlap at all

double site::score_overlap( prot_res *pr )
{
	if(pr->real_patch == NULL){
		return 0.0;
	}
	
  	int overlap = 0;
	int n1 = 0;
	int n2 = 0;

  	for(int i = 0; i< LENGTH; i++){
    	if(pr->real_patch[i] == PATCH) {
      		n2++;
		}
    	if(flag_patch[i] == PATCH){
			n1++;
    		if(pr->real_patch[i] == PATCH) {
      			overlap++;
			}
    	}
  	}
  	int n0 = (n1<n2) ? n1 : n2;

  	return (1.0 - overlap/(double)n0);
}

// Score 1.
// From conservation a score for the binding site
// Using average

double site::score_cns( prot_res *pr)
{
  double v1[patch.n];
  double v2[surf.n];
  double v3[core.n];

  for(int i=0; i< patch.n; i++){
    int u   = patch.v[i];
    v1[i] = pr->res[u].seq_cns;
  }
  cns_patch = dvec_stat(patch.n, v1, &cns_patch_std);

  for(int i=0; i< surf.n; i++){
    int u   = surf.v[i];
    v2[i] = pr->res[u].seq_cns;
  }
  cns_surf = dvec_stat(surf.n, v2, &cns_surf_std);

  for(int i=0; i< core.n; i++){
    int u   = core.v[i];
    v3[i] = pr->res[u].seq_cns;
  }
  cns_core = dvec_stat(core.n, v3, &cns_core_std);

	return (-cns_patch) ;// need tyo minimize energy and to max. cns
}

// Score circ determine the circolarity of the patch

double site::score_dist( prot_res *pr )
{

  int u,v;
  int n = 0;

  dist_ave = 0.0;
  dist_max = 0.0;

  for(int i=0; i< patch.n; i++){
    u = patch.v[i];
    for(int j=i+1; j< patch.n; j++){
      v = patch.v[j];
      if(u==v) continue;
      dist_ave += pr->dmap2[u][v];
      if(pr->dmap2[u][v] > dist_max){
	dist_max = pr->dmap2[u][v];
      }
      n++;
    }
  }

  if(n>1){ dist_ave /= (double)n; }

  return dist_ave;
}

// score electrostatics

double site::score_charge_density( prot_res *pr)
{
	double charge = 0.0;
	double psa = 0.0;
	
  	for(int i=0; i< patch.n; i++){
    	int u   = patch.v[i];
    	charge += pr->res[u].charge_exp;
		psa += pr->res[u].psa;
  	}
	
	return (charge / psa);
}

// score ept

double site::score_ept( prot_res *pr)
{
  double v1[patch.n];
  double v2[surf.n];
  double v3[core.n];

  for(int i=0; i< patch.n; i++){
    int u   = patch.v[i];
    v1[i] = pr->res[u].surf_ept;
  }
  ept_patch = dvec_stat(patch.n, v1, &ept_patch_std);

  for(int i=0; i< surf.n; i++){
    int u   = surf.v[i];
    v2[i] = pr->res[u].surf_ept;
  }
  ept_surf = dvec_stat(surf.n, v2, &ept_surf_std);

  for(int i=0; i< core.n; i++){
    int u   = core.v[i];
    v3[i] = pr->res[u].surf_ept;
  }
  ept_core = dvec_stat(core.n, v3, &ept_core_std);

	return ept_patch;
}

// temperature
double site::score_temp_exp( prot_res *pr)
{
	double temp = 0.0;
	double psa = 0.0;
	
  	for(int i=0; i< patch.n; i++){
    	int u   = patch.v[i];
    	temp += pr->res[u].temp_exp;
		psa += pr->res[u].psa;
  	}

	if(psa == 0.0){
		fprintf(stderr, "Warning: PSA_is_0 %f\n",psa);
	}
	
	temp_patch = (temp / psa);

	return (temp_patch) ;
}

// SCORE PROTRUSION
double site::score_protrusion( prot_res *pr )
{
  nres_protr = 0;
  nres_cavity = 0;

  for(int i=0; i<patch.n; i++){
    int u = patch.v[i];
    if( pr->res[u].protr == 'P')      { nres_protr++; }
    else if( pr->res[u].protr == 'C') { nres_cavity++; }
  }

  return (double) (nres_protr - nres_cavity)/patch.n;
}

// HYDROPHOBICITY
double site::score_hydro_miller( prot_res *pr, int debug )
{
  	hydro = 0.0;

	for(int i=0; i<patch.n; i++){
  		int u = patch.v[i];
		
  		if(debug>0) printf("%3d %3d",i,u);
		
  		for(int a=0; a<NAMINO; a++){
  			if(debug>0) printf(" %3d ",a);
			if( aa_interpreter[a].c == pr->cseq[u] ){
				hydro += aa_interpreter[a].hydro_miller;
				if(debug > 0){
    				printf("  AA_INTREPRETER  %3d %f \t%c %d\n", a, 
					aa_interpreter[a].hydro_miller,
					aa_interpreter[a].c, u);
  				}
				break;
			}
		}
	}

	hydro /= (double)patch.n;

	return hydro;
}


// SCORE CONVEXITY
double site::score_convexity( prot_res *pr )
{
  double div = 0.0;
  int n = 0;

  for(int i = 0; i< patch.n; i++){
    int k = patch.v[i];
    if(pr->res[k].surf.nb){
      div += pr->res[k].surf.div;
      n++;
    }
  }
  
  return (div/(double)n);
}

// Score cavity
/*double site::score_cavity( prot_res *pr )
{
  double div = 0.0;
  int n = 0;

  for(int i = 0; i< site.n; i++){
    int k = site.v[i];
    if( pr->res[k].cavity){

      n++;
    }
  }
  return (div/(double)n);
  }*/


void site::score_natm( prot_res *pr )
{
	num_tot     = 0;
	num_O       = 0;
	num_C       = 0;
	num_N       = 0;
	num_exposed = 0;
	num_buried  = 0;
	
	for(int i=0; i<patch.n; i++){
		int u = patch.v[i];
		for(int j=0; j< pr->res[u].natm; j++){
			num_tot++;
			if( pr->res[u].atm[j]->surf.surf_flag == 1 ){
				if     (pr->res[u].atm[j]->aname[0] == 'O') { num_O++;}
				else if(pr->res[u].atm[j]->aname[0] == 'C') { num_C++;}
				else if(pr->res[u].atm[j]->aname[0] == 'N') { num_N++;}
				else if(pr->res[u].atm[j]->aname[0] == 'S') { }
				else{
				  cout << pr->res[u].atm[j]->aname<<"\n";
				}
				num_exposed++;
			}
			else num_buried++;
		}
	}
}

/*
// STR CNS
void site::score_inf( prot_res *pr)
{
  inf_patch = 0.0;

  for(int i=0; i< patch.n; i++){
    int u = patch.v[i];
    inf_patch += pr->res[u].str_cns;
  }

  inf_patch /= (double) patch.n;
  inf_patch *= 100.0;

}
*/


/*
What's that? It looks a copy of overlap!!!!


void site::residues_in_common( site *site2)
{
  int n=0;
  for(int i=0; i< LENGTH;i++){
    if( flag_patch[i] == PATCH && site2->flag_patch[i] == PATCH){
      n++;
    }
  }

  overlap_lig = n;
}
*/
