/***************************************************
 *      FUNZIONI PER L"ALLOCCAZIONE DINAMICA
 *
 *
 *
 *
 *
 **************************************************/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

//#include "Include_all.h"


#ifndef _dynamic_
#define _dynamic_

struct dmat{
  int n;
  int m;
  double **mat;
} ;

struct imat{
  int n;
  int m;
  int **mat;
} ;

struct dvec{
  int n;
  double *vec;
} ;

struct ivec{
  int n;
  int *vec;
} ;

#endif

//mat
int    ** alloc_imat(int n, int m);
char   ** alloc_cmat(int n, int m);
double ** alloc_dmat(int n, int m);

void free_dmat(int n, double **mat);
void free_imat(int n, int    **mat);
void free_cmat(int n, char   **mat);

//mat 3d
int    *** alloc_imat_3d(int n1, int n2, int n3);
char   *** alloc_cmat_3d(int n1, int n2, int n3);
double *** alloc_dmat_3d(int n1, int n2, int n3);

void free_imat_3d(int n1, int n2, int    *** mat);
void free_cmat_3d(int n1, int n2, char   *** mat);
void free_dmat_3d(int n1, int n2, double *** mat);

//---
void alloc_struct_dmat(int n, int m, dmat * );
void alloc_struct_imat(int n, int m, imat * );

void alloc_struct_dvec(int n, dvec * );
void alloc_struct_ivec(int n, ivec * );
