
#include "basic_io.h"

int DEBUG_BASIC_IO = 0;

/*-----------------------------------------------------
Read an array of vectors (double) in stabdard format
(dimensions of arrays specified) from a file.
Use dynamic allocation.
-----------------------------------------------------*/

void load_imat(imat * imat, char * filename)
{
  int i,j;
  char str[100];
  int n_arg=0;
  FILE *fp;

  if(!(fp=fopen(filename,"r"))){ 
    printf("ERROR: file not found in load_pattern!\n");
    exit(0);
  }

  // find matrix dimensions

  while(n_arg != 2){
    if(fgets(str,100,fp) == NULL){
      printf("\nERROR: No line read in routine load_dmat\n");
      exit(0);
    }
    if(str[0] == '#') continue;
    n_arg = sscanf(str,"%d%d", &imat->n, &imat->m);
  }

  imat->mat = alloc_imat(imat->n,imat->m);

  // reading elements

  for(i=0; i< imat->n ; i++){
    for(j=0; j<imat->m ; j++){
      if(fscanf(fp,"%d", &imat->mat[i][j]) != 1){ 
	printf("\nERROR: Data missing for routine load-pattern\n");
	exit(0);
      }
      //printf("%4d %4d %d\n",i+1, j+1, imat->mat[i][j]);
    }
  }
  fclose(fp);
}
//
void load_dmat(dmat * dmat, char * filename)
{
  int i,j;
  char str[100];
  int n_arg=0;
  FILE *fp;

  if(!(fp=fopen(filename,"r"))){ 
    printf("ERROR: file not found in load_pattern!\n");
    exit(0);
  }

  // find matrix dimensions

  while(n_arg != 2){
    if(fgets(str,100,fp) == NULL){
      printf("\nERROR: No line read in routine load_dmat\n");
      exit(0);
    }
    if(str[0] == '#') continue;
    n_arg = sscanf(str,"%d%d", &dmat->n, &dmat->m);
  }

  dmat->mat = alloc_dmat(dmat->n,dmat->m);

  // reading elements

  for(i=0; i< dmat->n ; i++){
    for(j=0; j<dmat->m ; j++){
      if(fscanf(fp,"%lf", &dmat->mat[i][j]) != 1){ 
	printf("\nERROR: Data missing for routine load-pattern\n");
	exit(0);
      }
    }
  }

  // debugging

  if(DEBUG_BASIC_IO == 1){
  for(i=0; i< dmat->n ; i++){
    for(j=0; j<dmat->m ; j++){
      printf("%f ", dmat->mat[i][j]);
    }
    printf("\n");
  }
  }
  fclose(fp);
}

/*-------------
--fprintf--
----------------------------------*/
void fprintf_dmat(FILE *fp, char *format, int n, int m, double **mat)
{
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      fprintf(fp, format, mat[i][j]);
    } 
    fprintf(fp,"\n");
  }
  fprintf(fp,"\n");
  
}
//---
void fprintf_imat(FILE *fp, char *format, int n, int m, int **mat)
{
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      fprintf(fp, format, mat[i][j]);
    } 
    fprintf(fp,"\n");
  }
  fprintf(fp,"\n");
}
//---
void fprintf_dvec(FILE * fp, char *format, int n, double *vec)
{

  for(int i=0; i<n; i++){
      fprintf(fp, format, vec[i]);
  }
}
//---
void fprintf_ivec(FILE * fp, char *format, int n, int *vec)
{

  for(int i=0; i<n; i++){
      fprintf(fp, format, vec[i]);
  }
}
//---
void fprintf_cvec(FILE * fp, char *format, int n, char *vec)
{

  for(int i=0; i<n; i++){
      fprintf(fp, format, vec[i]);
  }
}
//--
void fprintf_n(FILE * fp)
{
  fprintf(fp,"\n");
}
//--
void fprintf_c(FILE * fp, int n, char c)
{
  for(int i=0; i<n; i++) fprintf(fp,"%c",c);
}


/*-------------------
--printf--
---------------*/
void printf_dmat( char *format, int n, int m, double **mat)
{
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      printf( format, mat[i][j]);
    } 
    printf("\n");
  }
  printf("\n");
  
}
//---
void printf_imat(char *format, int n, int m, int   **mat)
{
  for(int i=0;i<n;i++){
    for(int j=0;j<m;j++){
      printf( format, mat[i][j]);
    } 
    printf("\n");
  }
  printf("\n");
}
//---
void printf_dvec(char *format, int n, double *vec)
{
  for(int i=0;i<n;i++){
    printf(format, vec[i]);
  }
}
//---
void printf_ivec(char *format, int n, int *vec)
{ 
  for(int i=0;i<n;i++){
    printf(format, vec[i]);
  }
}
//--
void printf_n(void)
{
  printf("\n");
}
//--
void printf_c(int n, char c)
{
  for(int i=0; i<n; i++) printf("%c", c);
}

// fopen_read
FILE *fopen_read(char *file)
{
  FILE *fp = fopen(file, "r");
  if(fp==NULL){
    printf("I'm sorry but I didn't find file <%s>\n", file);
    exit(0);
  }
  return fp;
}
// fopen_write
FILE *fopen_write(char *file)
{
  FILE *fp = fopen(file, "w");
  if(fp == NULL){
    printf("I'm sorry but I couldn't open file <%s>\n", file);
    exit(0);
  }
  return fp;
}
/*-------------------------------------------*/
/*struct param{
  char   key[100];
  char   descr[100];
  char   *ps;
  char   *pc;
  int    *pi;
  double *pd;
  char   type;
  } ;*/

struct param param[100];

int nparam=0;

void get_options(int argc, char *argv[], int debug)
{
  char Usage[10000];
  if(nparam==0){
    fprintf(stderr, "Error:  Nparametri 0\n");
    exit(0);
  }

  // -- Usage
  strcpy (  Usage, "\n---\nOptions:\n");
  for(int j=0; j<nparam; j++){
    sprintf( Usage+strlen(Usage), "  %6s ->  %s\n", param[j].key, param[j].descr);
  }

  // -- Reading
  for(int i=1; i<argc; i++){
    int error = 0;
    for(int j=0; j<nparam; j++){
      	if(debug >0) printf("%d %d %s\n",i,j, argv[i]);
	  
      	if      ( strcmp( param[j].key,    argv[i])==0 ){ 
			if     (param[j].type=='c'){
	  			sscanf( argv[++i], "%c",   param[j].pc);
			}
			else if(param[j].type=='s'){
	 		 	sscanf( argv[++i], "%s",   param[j].ps);
			}
			else if(param[j].type=='i') 
	  			sscanf( argv[++i], "%d",   param[j].pi);
			else if(param[j].type=='d') 
	  			sscanf( argv[++i], "%lf",  param[j].pd);
			else{
	  			fprintf(stderr,"Error in getoptions\n");
	  			exit(0);
			}
			error++;
			break;
      	}
    }
    if(error != 1){
      printf( "Argv[%d] not recognized: <%s> \n", i, argv[i]);
      printf("%s\n", Usage);
      exit(0);
    }
    }

  // -- Printing values
  if(debug>0) printf("----------------------------------------------\n");
  if(debug>0) printf("Here is the input:\n");
  for(int j=0; j<nparam; j++){
    if(     param[j].type == 's'){ 
      if(debug>0){ 	printf("  %s   = %s\n", param[j].key, param[j].ps );}
    }  
    else if(param[j].type == 'c') {
      if(debug>0) printf("  %s   = %c\n", param[j].key, *param[j].pc );
    }
    else if(param[j].type == 'i'){ 
      if(debug>0) printf("  %s   = %d\n", param[j].key, *param[j].pi );
    }
    else if(param[j].type == 'd'){
      if(debug>0) printf("  %s   = %f\n", param[j].key, *param[j].pd );
    }
    else ;
  }
  if(debug>0) printf("----------------------------------------------\n");
}


void get_options_aux(void *pv, char key[], char descr[], char type)
{
  sprintf(param[nparam].key, "%s", key);
  sprintf(param[nparam].descr, "%s", descr);

  param[nparam].type= type;

  if(      type=='c') param[nparam].pc = (char *)pv;
  else if( type=='i') param[nparam].pi = (int *)pv;
  else if( type=='d') param[nparam].pd = (double *)pv;
  else{
    fprintf(stderr, "Error: in get_options_aux\n");
    exit(0);
  }
  nparam++;
}

void get_options_str(void *pv, char key[], char descr[], char def[])
{
  sprintf(param[nparam].key, "%s", key);
  sprintf(param[nparam].descr, "%s", descr);

  param[nparam].type= 's';
  param[nparam].ps = (char *)pv;
  sprintf(param[nparam].ps, "%s", def);
  printf("%s",param[nparam].ps);

  nparam++;
}
