#include "basic_stat.h"

/****************************************
******************************************
**       generali
******************************************
****************************************/

/**************************************************/
double dvec_entropy(int l, double *p)
{
  int i;
  double S;
  
  S=0.0;
  for(i=0;i<l;i++){
    if(p[i]> 0.000001)  S-= p[i]*log(p[i]);
  }
  return S/log((double)l);
}
/****************************************/
double cvec_hamming_succ(int l, char *s1, char *s2)
{
  int i;
  double d;
  
  for(i=0, d=0.0; i<l; i++){
    if(s1[i]==s2[i]) d+=1.0;
  }
  d /= (double)l;
  
  return d;
}
/****************************************/
double ivec_hamming_succ(int l, int *s1, int *s2)
{

  double d = 0.0;
  
  for( int i=0; i<l; i++){
    if(s1[i]==s2[i]) d+=1.0;
  }
  d /= (double)l;
  
  return d;
}
/*******************************************/
void   cvec_composition(int l, char *s, int n, double *f)
{
  int j;
  
  for(j=0; j<n; j++) f[j]=0;
  for(j=0; j<l; j++) f[s[j]]+=1.0;
  for(j=0; j<n; j++) f[j] /= (double)l;

}
/*******************************************/
int dvec_max(int l, double * v)
{
  int i;
  int imax;
  double vmax;

  imax = 0;
  vmax = v[0];

  for(i=1; i<l; i++){

    if(v[i] > vmax){ 
      vmax = v[i];
      imax = i;
    }
  }

  return imax;
}
/*******************************************/
int dvec_min(int l, double * v)
{
  int i;
  int imin;
  double vmin;

  imin = 0;
  vmin = v[0];

  for(i=1; i<l; i++){

    if(v[i] < vmin){ 
      vmin = v[i];
      imin = i;
    }
  }

  return imin;
}
/*******************************************/
int dvec_amax(int l, double * v)
{
  int i;
  int imax;
  double v0;
  double vmax;

  imax = 0;
  vmax = fabs(v[0]);

  for(i=1; i<l; i++){
    v0 = fabs(v[i]);
    if(v0 > vmax){ 
      vmax = v0;
      imax = i;
    }
  }

  return imax;
}
/*******************************************/
int ivec_max(int l, int * v, int * vmax)
{
  int i;
  int imax;


  imax = 0;
  *vmax = v[0];

  for(i=1; i<l; i++){

    if(v[i] > *vmax){ 
      *vmax = v[i];
      imax = i;
    }
  }

  return imax;
}
/*******************************************/
double dvec_stat(int n, double v[], double * std)
{
  int i;
  double ave;
  
  ave=*std=0.0;
  
  for(i=0; i<n ;i++){
    ave += v[i];
    *std += v[i]*v[i];
  }
  
  ave/=n;
  *std=sqrt(*std/n - ave*ave);

  return ave;
}
/*******************************************/
void dmat_stat(int n, int m, double **mat, double * vec_ave, double * vec_std)
{
  int i,j;

  for(i=0; i<n; i++){
    for(j=0; j<m; j++){
      vec_ave[j] += mat[i][j];
      vec_std[j] += (mat[i][j] * mat[i][j]);
    }
  }
  
  for(j=0; j<m; j++){
    vec_ave[j] /= n;
    vec_std[j] = sqrt( vec_std[j]/n - vec_ave[j] * vec_ave[j]);
  }
}
/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/
