#include "basic_vec.h"



/*******************************************
    vettori double
********************************************/

/*********************************************/
void dvec_init(int l, double * v, double x)
{
  for( int i=0; i<l; i++)  v[i]=x;
}
/**********************************************/
void dvec_add(int l, double * v, double x)
{
  for( int i=0; i<l; i++)  v[i] += x;
}
/**********************************************/
void dvec_scal(int l, double * v, double x)
{
  for( int i=0; i<l; i++)  v[i] *= x;
}
/**********************************************/
void dvec_sum(int l, double av, double * v, double au, double * u)
{
  for(int i=0; i<l; i++)  v[i] = av*v[i] + au*u[i];
}
/**********************************************/
void dvec_sum_xyz(int l, double * z, double av, double * v, double au, double * u)
{
  for(int i=0; i<l; i++)  z[i] = av*v[i] + au*u[i];
}
/**************************************************/
void dvec_cp(int l, double * u, double * v)
{
  for(int i=0; i<l; i++) u[i]= v[i];
}
/*************************/
double dvec_scalar(int l, double v[], double u[])
{

  double x=0.0;
  
  for(int i=0; i<l; i++) x+=u[i]*v[i];

  return x;
}
/**************************************************/
void dvec_vectorial( double v[], double v1[], double v2[])
{
  v[0]=+(v1[1]*v2[2]-v1[2]*v2[1]);
  v[1]=-(v1[0]*v2[2]-v1[2]*v2[0]);
  v[2]=+(v1[0]*v2[1]-v1[1]*v2[0]);
}

/************************************************/
double dvec_length(int l, double v[])
{

  double x=0.0;

  for(int i=0;i<l;i++)  x+=v[i]*v[i];

  x=sqrt(x);

  return x;
}

/*********/
double dvec_distance(int l, double v1[], double v2[])
{
  double x;
  double distance = 0.0;

  for(int i=0; i<l; i++){
    x = v2[i]-v1[i];
    distance += x*x;
  }

  return sqrt(distance);
}

/************************************************/
void dvec_norm(int l, double v[])
{
  int i;
  double x=0.0;
  
  for(i=0;i<l;i++)  x+=v[i]*v[i];
  x=sqrt(x);
  for(i=0;i<l;i++) v[i]/=x;  
}
/************************************************/
void dvec_norm_prob(int l, double v[])
{
  int i;
  double x=0.0;
  
  for(i=0;i<l;i++)  x+=v[i];

  for(i=0;i<l;i++) v[i]/=x;  
}


/******************************************
    vettori interi
********************************/
void ivec_cp(int l, int * u, int * v)
{
  int i;

  for(i=0; i<l; i++) u[i]= v[i];
}
/**************************************************/
void ivec_sum(int l, int av, int * v, int au, int * u)
{
  int i;

  for(i=0; i<l; i++)  v[i]=av*v[i]+au*u[i];
}
/**********************************************/
void ivec_scal(int l, int * v, int x)
{
 int i;

  for(i=0; i<l; i++)  v[i] *= x;

}
/**********************************************/
void ivec_init(int l, int * v, int x)
{
 int i;

  for(i=0; i<l; i++)  v[i]=x;
}
/**************************************************/
int ivec_scalar(int l, int v[], int u[])
{
  int i;
  int x=0;
  
  for(i=0; i<l; i++) x += u[i]*v[i];

  return x;
}
/****************************************
VETTORI CHARACTERS
 ***********************************/
void cvec_init(int l, char * v, char x)
{
 int i;

  for(i=0; i<l; i++)  v[i]=x;

  v[l-1]='\n';
}
/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/
