#include "Include_basic_local.h"

#define NROWMAX 50000
//#define LMAX    5000  // Max length of chain

#define NCOLMAX 85

#define ATOM   "ATOM  "
#define HETATM "HETATM"
#define TER    "TER   "
#define ENDMDL "ENDMDL"
#define END    "END   "

#ifndef _pdb_atom_aux_

struct atm_surf{
  int surf_flag;  
  int norm_flag;
  double norm[3];
  int ncm;
  double cm[3];
};

class atom{
  friend class prot_res;
  //--VARIABLES--
 public:
  char chain;
  double xyz[3];
  int resnum;
  char resname[4];
  int anum;
  char aname[5];
  char altloc;
  char icode;
  double occup,temp;
  double rad,sol;
	double charge;
	// calculated data
  char protr;
  int nnst;
  struct nst *nst;
  struct atm_surf surf;
  
  //--FUNTIONS--
 public:

  // Functions to create PDB format
  atom( void ){
    //cout << "Create atom";
    temp  = 0.0;
    occup = 0.0;
    rad   = 0.0;
    sol   = 0.0;
	charge = 0.0;
  }
  ~atom( void ){}//{cout << "Destroy atom\n";}
  void print_buffer( char buffer[] );
  void copy( atom *atm);
  void read_pdb( char buffer[]);
  void read_rad_sol( char buffer[]);

  // get
  int get_resnum(){ return resnum;}
  // print on buffer
  inline void print_atom   ( char buffer[]);
  inline void print_anum   ( char buffer[]);
  inline void print_aname  ( char buffer[]);
  inline void print_resnum ( char buffer[]);
  inline void print_icode  ( char buffer[]);
  inline void print_chain  ( char buffer[]);
  inline void print_altloc ( char buffer[]);
  inline void print_resname( char buffer[]);
  inline void print_xyz    ( char buffer[]);
  inline void print_occup  ( char buffer[]);
  inline void print_temp   ( char buffer[]);

  inline void read_anum( char buffer[]);
  inline void read_aname( char buffer[]);
  inline void read_altloc( char buffer[]);
  inline void read_resname( char buffer[]);
  inline void read_chain( char buffer[]);
  inline void read_resnum( char buffer[]);
  inline void read_icode( char buffer[]);
  inline void read_xyz( char buffer[]);
  void read_temp(char buffer[]);
  void read_charge(char buffer[]);
};

// --- fast,  not object oriented
/*void read_anum( char buffer[], int *anum);
void read_aname( char buffer[], char aname[]);
void read_altloc( char buffer[], char altloc);
void read_resname( char buffer[], char *resname);
void read_chain( char buffer[], char *chain);
void read_resnum( char buffer[], int *resnum);
void read_icode( char buffer[], char *icode);
void read_xyz( char buffer[], double xyz[]);
void read_temp(char buffer[], double temp);
void read_sol( char buffer[], double *rad, double *sol);
*/


#define _pdb_atom_aux_
#endif
