/*-----
Sequence conversion routines
----- */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "Include_basic_local.h"


#define NAMINO 20

#ifndef _prot_seq_



/*----------------------------------------
Amino acid translation 
---------------------------------------*/
const struct 
{
  char name[20]; 
  char s[4]; 
  char c; 
  int i;
  double f;
  double hydro_miller;
} aa_interpreter[NAMINO] ={
   { "Alanine",       "ALA",  'A',  0,   8.3, -0.20 },
   { "Arginine",      "ARG",  'R',  1,   5.7,  1.34 },
   { "Asparagine",    "ASN",  'N',  2,   4.4,  0.69 },
   { "Aspartic acid", "ASP",  'D',  3,   5.3,  0.72 },
   { "Cysteine",      "CYS",  'C',  4,   1.7, -0.67 },
   { "Glutamine",     "GLN",  'Q',  5,   4.0,  0.74 },
   { "Glutamic acid", "GLU",  'E',  6,   6.2,  1.09 },
   { "Glycine",       "GLY",  'G',  7,   7.2, -0.06 },
   { "Histidine",     "HIS",  'H',  8,   2.2, -0.04 },
   { "Isoleucine",    "ILE",  'I',  9,   5.2, -0.74 },
   { "Leucine",       "LEU",  'L',  10,  9.0, -0.65 },
   { "Lysine",        "LYS",  'K',  11,  5.7,  2.00 },
   { "Methionine",    "MET",  'M',  12,  2.4, -0.71 },
   { "Phenylalanine", "PHE",  'F',  13,  3.9, -0.67 },
   { "Proline",       "PRO",  'P',  14,  5.1, -0.44 },
   { "Serine",        "SER",  'S',  15,  6.9,  0.34 },
   { "Threonine",     "THR",  'T',  16,  5.8,  0.26 },
   { "Tryptophan",    "TRP",  'W',  17,  1.3, -0.45 },
   { "Tyrosine",      "TYR",  'Y',  18,  3.2,  0.22 },
   { "Valine",        "VAL",  'V',  19,  6.6, -0.61 }
};


extern double AA_FREQ[];

struct aa_cls 
{
  int ncl;
  int vec[NAMINO];
} ;

extern struct aa_cls cls2_dill;
extern struct aa_cls cls3_dill;
extern struct aa_cls cls4_dill;
extern struct aa_cls cls5_dill;
extern struct aa_cls cls6_dill;
extern struct aa_cls cls8_pancho;
extern struct aa_cls cls12;
extern struct aa_cls cls20;

extern const int nmcls;
extern const struct aa_cls *mcls[];
#define _prot_seq_
#endif



void conv_cs_is(int l, int *is, char *cs);
void conv_is_cs(int l, char *cs, int *is);

void fprintf_iseq(FILE *fp, int l, int *seq);

void conv_is20_is_cls(int l, int *is, int *is20, const aa_cls cls[]);
void conv_cs_is_cls  (int l, int *is, char *cs,  const aa_cls *cls);

char  conv_3lett_1lett( char stype[3]);


struct aa_cls *num_to_cls(int ncl);
struct aa_cls *name_to_cls(char *name);
